/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.properties;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PropertyPage;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.bind.BindProjectsWizard;
import org.sonarlint.eclipse.ui.internal.server.wizard.NewServerLocationWizard;

public class SonarProjectPropertyPage
extends PropertyPage {
    private Button enabledBtn;
    private Link addServerLink;
    private Link bindLink;
    private Composite container;
    private Label boundDetails;

    public SonarProjectPropertyPage() {
        this.setTitle(Messages.SonarProjectPropertyPage_title);
    }

    protected Control createContents(Composite parent) {
        if (parent == null) {
            return new Composite(parent, 0);
        }
        SonarLintProject sonarProject = SonarLintProject.getInstance((IResource)this.getProject());
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        this.enabledBtn = new Button(this.container, 32);
        this.enabledBtn.setText("Run SonarLint automatically");
        this.enabledBtn.setSelection(sonarProject.isAutoEnabled());
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.enabledBtn.setLayoutData((Object)layoutData);
        this.boundDetails = new Label(this.container, 0);
        this.boundDetails.setLayoutData((Object)new GridData(768));
        this.addServerLink = new Link(this.container, 0);
        GridData gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 2;
        this.addServerLink.setLayoutData((Object)gd);
        this.addServerLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverId = SonarLintProject.getInstance((IResource)SonarProjectPropertyPage.this.getProject()).getServerId();
                NewServerLocationWizard wizard = new NewServerLocationWizard(serverId);
                WizardDialog wd = new WizardDialog(SonarProjectPropertyPage.this.container.getShell(), (IWizard)wizard);
                if (wd.open() == 0) {
                    SonarProjectPropertyPage.this.updateState();
                }
            }
        });
        this.bindLink = new Link(this.container, 0);
        gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 2;
        this.bindLink.setLayoutData((Object)gd);
        this.bindLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindProjectsWizard wizard = new BindProjectsWizard(Arrays.asList(SonarProjectPropertyPage.this.getProject()));
                WizardDialog wd = new WizardDialog(SonarProjectPropertyPage.this.container.getShell(), (IWizard)wizard);
                if (wd.open() == 0) {
                    SonarProjectPropertyPage.this.updateState();
                }
            }
        });
        this.updateState();
        return this.container;
    }

    private void updateState() {
        SonarLintProject sonarProject = SonarLintProject.getInstance((IResource)this.getProject());
        String moduleKey = sonarProject.getModuleKey();
        String serverId = sonarProject.getServerId();
        if (moduleKey == null && serverId == null) {
            this.bindLink.setText("<a>Bind this Eclipse project to a SonarQube project</a>");
            this.boundDetails.setText("");
        } else {
            this.boundDetails.setText("Bound to the project '" + moduleKey + "' on server '" + SonarProjectPropertyPage.serverName(serverId) + "'");
            this.bindLink.setText("<a>Update project binding</a>");
        }
        if (serverId != null && ServersManager.getInstance().getServer(serverId) == null) {
            this.addServerLink.setText("<a>Connect to SonarQube server '" + serverId + "'</a>");
            this.addServerLink.setVisible(true);
        } else {
            this.addServerLink.setVisible(false);
        }
        this.container.layout(true, true);
    }

    private static String serverName(String serverId) {
        if (serverId == null) {
            return "";
        }
        IServer server = ServersManager.getInstance().getServer(serverId);
        return server != null ? server.getName() : "Unknown server: '" + serverId + "'";
    }

    protected void performDefaults() {
        this.enabledBtn.setEnabled(true);
        super.performDefaults();
    }

    public boolean performOk() {
        SonarLintProject sonarProject = SonarLintProject.getInstance((IResource)this.getProject());
        sonarProject.setAutoEnabled(this.enabledBtn.getSelection());
        sonarProject.setBuilderEnabled(this.enabledBtn.getSelection());
        sonarProject.save();
        return super.performOk();
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

